/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import vlcskineditor.Item;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.GroupEditEvent;
import vlcskineditor.history.ItemAddEvent;
import vlcskineditor.items.Anchor;
import vlcskineditor.items.Button;
import vlcskineditor.items.Checkbox;
import vlcskineditor.items.Image;
import vlcskineditor.items.Playtree;
import vlcskineditor.items.RadialSlider;
import vlcskineditor.items.Slider;
import vlcskineditor.items.Text;
import vlcskineditor.items.Video;

public class Group
extends Item
implements ActionListener {
    public List<Item> items = new LinkedList<Item>();
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;

    /*
     * WARNING - void declaration
     */
    public Group(String string, Skin skin) {
        int n;
        this.type = "Group";
        this.s = skin;
        String[] stringArray = string.split("\n");
        if (stringArray[0].indexOf("x=\"") != -1) {
            this.x = XML.getIntValue(stringArray[0], "x");
        }
        if (stringArray[0].indexOf("y=\"") != -1) {
            this.y = XML.getIntValue(stringArray[0], "y");
        }
        this.id = stringArray[0].indexOf("id=\"") != -1 ? XML.getValue(stringArray[0], "id") : "Unnamed group #" + this.s.getNewId();
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringArray[n].trim();
        }
        for (n = 1; n < stringArray.length; ++n) {
            void var5_16;
            if (stringArray[n].startsWith("<!--")) {
                while (stringArray[n].indexOf("-->") == -1) {
                    ++n;
                }
                continue;
            }
            if (stringArray[n].startsWith("<Anchor")) {
                this.items.add(new Anchor(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Button")) {
                this.items.add(new Button(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Checkbox")) {
                this.items.add(new Checkbox(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Image")) {
                this.items.add(new Image(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Text")) {
                this.items.add(new Text(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Video")) {
                this.items.add(new Video(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<RadialSlider")) {
                this.items.add(new RadialSlider(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Playlist")) {
                void var5_8;
                String string2 = stringArray[n];
                ++n;
                while (!stringArray[n].startsWith("</Playlist>")) {
                    String string3 = (String)var5_8 + "\n" + stringArray[n];
                    ++n;
                }
                String string4 = (String)var5_8 + "\n" + stringArray[n];
                this.items.add(new Playtree(string4, this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Playtree")) {
                void var5_12;
                String string5 = stringArray[n];
                ++n;
                while (!stringArray[n].startsWith("</Playtree>")) {
                    String string6 = (String)var5_12 + "\n" + stringArray[n];
                    ++n;
                }
                String string7 = (String)var5_12 + "\n" + stringArray[n];
                this.items.add(new Playtree(string7, this.s));
                continue;
            }
            if (!stringArray[n].startsWith("<Slider")) continue;
            if (stringArray[n].indexOf("/>") != -1) {
                this.items.add(new Slider(stringArray[n], this.s));
                continue;
            }
            String string8 = stringArray[n];
            ++n;
            while (!stringArray[n].startsWith("</Slider>")) {
                String string9 = (String)var5_16 + "\n" + stringArray[n];
                ++n;
            }
            String string10 = (String)var5_16 + "\n" + stringArray[n];
            this.items.add(new Slider(string10, this.s));
        }
        for (Item item : this.items) {
            item.setOffset(this.x, this.y);
        }
        this.created = true;
    }

    public Group(Skin skin) {
        this.type = "Group";
        this.s = skin;
        this.id = "Unnamed group #" + this.s.getNewId();
        this.showOptions();
        this.s.updateItems();
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            for (Item item : this.items) {
                item.setOffset(this.x, this.y);
            }
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setDefaultCloseOperation(1);
            this.created = true;
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
        } else {
            GroupEditEvent groupEditEvent = new GroupEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            for (Item item : this.items) {
                item.setOffset(this.x, this.y);
            }
            this.s.updateItems();
            this.s.expandItem(this.id);
            groupEditEvent.setNew();
            this.s.m.hist.addEvent(groupEditEvent);
        }
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame("Group settings");
            this.frame.setResizable(false);
            this.frame.setLayout(new FlowLayout());
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel("ID*:");
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel("X:");
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel("Y:");
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            this.ok_btn = new JButton("OK");
            this.ok_btn.addActionListener(this);
            this.ok_btn.setPreferredSize(new Dimension(70, 25));
            this.cancel_btn = new JButton("Cancel");
            this.cancel_btn.addActionListener(this);
            this.cancel_btn.setPreferredSize(new Dimension(70, 25));
            this.help_btn = new JButton("Help");
            this.help_btn.addActionListener(this);
            this.help_btn.setPreferredSize(new Dimension(70, 25));
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            jLabel.setBounds(5, 15, 75, 24);
            this.id_tf.setBounds(85, 15, 150, 24);
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            jLabel2.setBounds(5, 45, 75, 24);
            this.x_tf.setBounds(85, 45, 150, 24);
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            jLabel3.setBounds(5, 75, 75, 24);
            this.y_tf.setBounds(85, 75, 75, 24);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "General Attributes"));
            jPanel.setMinimumSize(new Dimension(240, 110));
            jPanel.setPreferredSize(new Dimension(240, 110));
            jPanel.setMaximumSize(new Dimension(240, 110));
            this.frame.add(jPanel);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(new JLabel("* required attribute"));
            this.frame.setMinimumSize(new Dimension(250, 180));
            this.frame.setPreferredSize(new Dimension(250, 180));
            this.frame.setMaximumSize(new Dimension(250, 180));
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please enter a valid ID!", "ID not valid", 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, "The ID \"" + this.id_tf.getText() + "\" already exists, please choose another one.", "ID not valid", 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/i-group.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/i-group.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Group";
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        string2 = string2 + ">";
        for (int i = 0; i < this.items.size(); ++i) {
            string2 = string2 + "\n" + this.items.get(i).returnCode(string + Skin.indentation);
        }
        string2 = string2 + "\n" + string + "</Group>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, this.offsetx, this.offsety, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        for (Item item : this.items) {
            item.draw(graphics2D, this.x + this.x, this.y + n2, n3);
            item.setOffset(this.x + this.offsetx, this.y + this.offsety);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        return n >= this.x + this.offsetx && n2 >= this.y + this.offsety;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Group: " + this.id);
        for (int i = 0; i < this.items.size(); ++i) {
            defaultMutableTreeNode.add(this.items.get(i).getTreeNode());
        }
        return defaultMutableTreeNode;
    }

    @Override
    public Item getItem(String string) {
        if (this.id.equals(string)) {
            return this;
        }
        for (Item item : this.items) {
            if (item.getItem(string) == null) continue;
            return item.getItem(string);
        }
        return null;
    }

    @Override
    public List<Item> getParentListOf(String string) {
        for (Item item : this.items) {
            List<Item> list;
            if (item.id.equals(string)) {
                return this.items;
            }
            if (!item.type.equals("Group") && !item.type.equals("Panel") || (list = item.getParentListOf(string)) == null) continue;
            return list;
        }
        return null;
    }

    @Override
    public Item getParentOf(String string) {
        for (Item item : this.items) {
            if (item.id.equals(string)) {
                return this;
            }
            Item item2 = item.getParentOf(string);
            if (item2 == null) continue;
            return item2;
        }
        return null;
    }

    @Override
    public boolean uses(String string) {
        for (Item item : this.items) {
            if (!item.uses(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renameForCopy(String string) {
        String string2 = string;
        super.renameForCopy(string);
        for (Item item : this.items) {
            item.renameForCopy(string2);
        }
    }
}

