#if !defined (__COMMANDFRAMEEXCEPTION_HPP)
#define __COMMANDFRAMEEXCEPTION_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

namespace corelinux
{


   DECLARE_CLASS( CommandFrameException );

   /**
   CommandFrameException is the base exception type for CommandFrame. All
   CommandFrame exceptions derive from this.
   */

   class CommandFrameException : public Exception
   {
   
   public:
   
                        /**
                        Default Constructor
                        @param why describes why the exception was thrown
                        @param file The source module throwing the exception
                        @param line The line of source throwing the exception
                        @param severity The Exception::Severity of the Exception
                        @param outOfMemory An out of memory indicator
                        */

                        CommandFrameException
                        (
                           CharCptr why,
                           CharCptr file,
                           LineNum  line,
                           Severity severity = Exception::CONTINUABLE,
                           bool     outOfMemory = false 
                        );

                        /**
                        Default Constructor
                        @param file The source module throwing the exception
                        @param line The line of source throwing the exception
                        @param severity The Exception::Severity of the Exception
                        @param outOfMemory An out of memory indicator
                        */

                        CommandFrameException
                        (
                           CharCptr file,
                           LineNum  line,
                           Severity severity = Exception::CONTINUABLE,
                           bool     outOfMemory = false 
                        );
   
                        /**
                        Copy constructor
                        @param CommandFrameException const reference
                        */
                     
                        CommandFrameException( CommandFrameExceptionCref );
   
                        /// Virtual Destructor
   
      virtual           ~CommandFrameException( void );
   
         //
         // Operator overloads
         //
   
               /**
               Assignment operator overload
               @param  CommandFrameException const reference
               @return CommandFrameException reference to self
               */
            
               CommandFrameExceptionRef   operator=( CommandFrameExceptionCref );
            
               /**
               Equality operator overload
               @param CommandFrameException const reference
               @return true if equal, false otherwise
               */

               bool           operator==( CommandFrameExceptionCref ) const;
            
         //
         // Accessor methods
         //
   
            
         //
         // Mutator methods
         //
   
   
   protected:

                        /**
                        CommandFrameException must have at least
                        a location..
                        Default constructor is not allowed.
                        */   
                     
                        CommandFrameException( void );
   };

}


#endif  // !defined __COMMANDFRAMEEXCEPTION_HPP

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/03 03:56:47 $
   $Locker:  $
*/



