#if   !defined(__OBSERVER_HPP)
#define __OBSERVER_HPP

/*
   CoreLinux++ 
   Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__EVENT_HPP)
#include <Event.hpp>
#endif


namespace corelinux
{
   DECLARE_CLASS( Subject );
   DECLARE_CLASS( Observer );

   /**
   Observer observes Subjets and supports the event interface for
   recieving subject event notifications.

   */

   class Observer
   {
   public:

      //
      // Constructors and destructor
      //

                        /**
                        Default constructor 
                        */

                        Observer( void ) ;

                        /**
                        Copy constructor 
                        @param Observer const referencee
                        */

                        Observer( ObserverCref );

                        /// Virtual destructor 

      virtual           ~Observer( void );   

      //
      // Operator overloads
      //

               /// Assignment operator

               ObserverRef   operator=( ObserverCref );

               /// Equality operator

               bool operator==( ObserverCref ) const;

               /// In-Equality operator

               bool operator!=( ObserverCref ) const;
      //
      // Accessors
      //


      //
      // Mutators
      //

               /**
               Called by Subject::notifyObservers if this
               observer instance is registered for the event type.
               @param Event the type of event interested in
               @exception NullPointer exception if event is null
               */

      virtual  void  event( Event<Identifier> * ) 
                  throw ( NullPointerException );

   protected:

   private:

   };
}

#endif // if !defined(__OBSERVER_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:52:20 $
   $Locker:  $
*/



