package esmska.gui;

import esmska.data.Config;
import esmska.data.Icons;
import esmska.data.SMS;
import esmska.gui.GatewayMessageFrame.TaskPane;
import esmska.utils.RuntimeUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.SwingConstants;
import org.apache.commons.lang.StringUtils;
import org.openide.awt.Mnemonics;

/** Image code recognition request from a gateway displayed to the user
 *
 * @author ripper
 */
public class GatewayImageCodeMessage extends GatewayMessage {
    private static final Config config = Config.getInstance();
    private static final ImageIcon ICON = Icons.get("keyring-16.png");
    /** Remember the SMS we received */
    private SMS sms;

    /** Creates new form GatewayImageCodeMessage */
    public GatewayImageCodeMessage() {
        initComponents();

        //sort buttons
        Object[] buttons = RuntimeUtils.sortOptions(cancelButton, okButton);
        buttonPanel.removeAll();
        buttonPanel.add((Component)buttons[0]);
        buttonPanel.add((Component)buttons[1]);

        //if not Substance LaF, add clipboard popup menu to text components
        if (!config.getLookAndFeel().equals(ThemeManager.LAF.SUBSTANCE)) {
            ClipboardPopupMenu.register(codeTextField);
        }
    }

    /** Initialize this message to show an image code request message
     * @param sms sms that needs image code to be resolved
     */
    public TaskPane showImageCodeMsg(SMS sms) {
        this.sms = sms;
        
        if (sms.getImage() == null && StringUtils.isEmpty(sms.getImageHint())) {
            cancelButtonActionPerformed(null);
        }

        String recipient = extractRecipient(sms);
        String title = MessageFormat.format(l10n.getString("GatewayImageCodeMessage.securityImage"), recipient);
        Icon icon = ICON;

        imageLabel.setIcon(sms.getImage());
        imageLabel.setText("<html><i>" + sms.getImageHint() + "</i></html>");

        return wrapAsTaskPane(this, title, icon);
    }

    @Override
    public void setBestFocus() {
        codeTextField.requestFocusInWindow();
    }

    @Override
    public void cancel() {
        cancelButton.doClick(0);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        imageLabel = new JHtmlLabel();
        codeTextField = new JTextField();
        jLabel2 = new JLabel();
        buttonPanel = new JPanel();
        cancelButton = new JButton();
        okButton = new JButton();

        imageLabel.setHorizontalAlignment(SwingConstants.CENTER);
        imageLabel.setIcon(new ImageIcon(getClass().getResource("/esmska/resources/missing-image-64.png"))); // NOI18N
        imageLabel.setHorizontalTextPosition(SwingConstants.CENTER);
        imageLabel.setVerticalTextPosition(SwingConstants.TOP);

        codeTextField.addKeyListener(new KeyAdapter() {
            public void keyReleased(KeyEvent evt) {
                codeTextFieldKeyReleased(evt);
            }
        });

        jLabel2.setLabelFor(codeTextField);

        Mnemonics.setLocalizedText(jLabel2, l10n.getString("GatewayImageCodeMessage.jLabel2.text"));
        buttonPanel.setLayout(new GridLayout(1, 0, 5, 0));
        Mnemonics.setLocalizedText(cancelButton, l10n.getString("Cancel_"));
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(cancelButton);
        Mnemonics.setLocalizedText(okButton, l10n.getString("OK_"));
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(okButton);

        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(Alignment.LEADING)
                    .addComponent(imageLabel, GroupLayout.DEFAULT_SIZE, 145, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(ComponentPlacement.RELATED)
                        .addComponent(codeTextField, GroupLayout.DEFAULT_SIZE, 50, Short.MAX_VALUE))
                    .addComponent(buttonPanel, Alignment.TRAILING, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(imageLabel, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(codeTextField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(ComponentPlacement.RELATED)
                .addComponent(buttonPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void codeTextFieldKeyReleased(KeyEvent evt) {//GEN-FIRST:event_codeTextFieldKeyReleased
        if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
            okButton.doClick(0);
        }
    }//GEN-LAST:event_codeTextFieldKeyReleased

    private void cancelButtonActionPerformed(ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        sms.setImageCode(null);
        actionSupport.fireActionPerformed(CLOSE_ME, null);
}//GEN-LAST:event_cancelButtonActionPerformed

    private void okButtonActionPerformed(ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        sms.setImageCode(codeTextField.getText());
        actionSupport.fireActionPerformed(CLOSE_ME, null);
}//GEN-LAST:event_okButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JTextField codeTextField;
    private JHtmlLabel imageLabel;
    private JLabel jLabel2;
    private JButton okButton;
    // End of variables declaration//GEN-END:variables
}
