/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.awt.CCheckboxMenuItem;
import apple.awt.CMenuItem;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaMenuItemUI;
import com.apple.laf.ScreenMenuItemUI;
import com.apple.laf.ScreenMenuPropertyHandler;
import com.apple.laf.ScreenMenuPropertyListener;
import java.awt.CheckboxMenuItem;
import java.awt.Image;
import java.awt.MenuContainer;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.MenuComponentPeer;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.plaf.ButtonUI;

class ScreenMenuItemCheckbox
extends CheckboxMenuItem
implements ActionListener,
ComponentListener,
ScreenMenuPropertyHandler,
ItemListener {
    JMenuItem fMenuItem;
    MenuContainer fParent;
    ScreenMenuPropertyListener fPropertyListener;

    ScreenMenuItemCheckbox(JCheckBoxMenuItem jCheckBoxMenuItem) {
        super(jCheckBoxMenuItem.getText(), jCheckBoxMenuItem.getState());
        this.init(jCheckBoxMenuItem);
    }

    ScreenMenuItemCheckbox(JRadioButtonMenuItem jRadioButtonMenuItem) {
        super(jRadioButtonMenuItem.getText(), jRadioButtonMenuItem.getModel().isSelected());
        this.init(jRadioButtonMenuItem);
    }

    public void init(JMenuItem jMenuItem) {
        this.fMenuItem = jMenuItem;
        this.setEnabled(this.fMenuItem.isEnabled());
    }

    @Override
    public void addNotify() {
        String string;
        super.addNotify();
        CCheckboxMenuItem cCheckboxMenuItem = (CCheckboxMenuItem)this.getPeer();
        cCheckboxMenuItem.setAutoToggle(false);
        this.fMenuItem.addComponentListener(this);
        this.fPropertyListener = new ScreenMenuPropertyListener(this);
        this.fMenuItem.addPropertyChangeListener(this.fPropertyListener);
        this.addActionListener(this);
        this.addItemListener(this);
        this.fMenuItem.addItemListener(this);
        this.setIndeterminate(AquaMenuItemUI.IndeterminateListener.isIndeterminate(this.fMenuItem));
        this.setAccelerator(this.fMenuItem.getAccelerator());
        Icon icon = this.fMenuItem.getIcon();
        if (icon != null) {
            this.setIcon(icon);
        }
        if ((string = this.fMenuItem.getToolTipText()) != null) {
            this.setToolTipText(string);
        }
        this.fMenuItem.addItemListener(this);
        ButtonUI buttonUI = this.fMenuItem.getUI();
        if (buttonUI instanceof ScreenMenuItemUI) {
            ((ScreenMenuItemUI)((Object)buttonUI)).updateListenersForScreenMenuItem();
        }
        if (this.fMenuItem instanceof JCheckBoxMenuItem) {
            this.setState(((JCheckBoxMenuItem)this.fMenuItem).isSelected());
        } else {
            this.setState(this.fMenuItem.getModel().isSelected());
        }
    }

    @Override
    public void removeNotify() {
        this.fMenuItem.removeComponentListener(this);
        this.fMenuItem.removePropertyChangeListener(this.fPropertyListener);
        this.fPropertyListener = null;
        this.removeActionListener(this);
        this.removeItemListener(this);
        this.fMenuItem.removeItemListener(this);
        super.removeNotify();
    }

    @Override
    public void setAccelerator(KeyStroke keyStroke) {
        if (keyStroke == null) {
            this.setShortcut(null);
            return;
        }
        MenuComponentPeer menuComponentPeer = this.getPeer();
        if (menuComponentPeer instanceof CMenuItem) {
            CMenuItem cMenuItem = (CMenuItem)menuComponentPeer;
            cMenuItem.setLabel(this.fMenuItem.getText(), keyStroke.getKeyChar(), keyStroke.getKeyCode(), keyStroke.getModifiers());
        } else {
            this.setShortcut(new MenuShortcut(keyStroke.getKeyCode(), (keyStroke.getModifiers() & 1) != 0));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fMenuItem.doClick(0);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.setVisible(true);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.setVisible(false);
    }

    @Override
    public void setToolTipText(String string) {
        MenuComponentPeer menuComponentPeer = this.getPeer();
        if (!(menuComponentPeer instanceof CMenuItem)) {
            return;
        }
        ((CMenuItem)menuComponentPeer).setToolTipText(string);
    }

    @Override
    public void setIcon(Icon icon) {
        MenuComponentPeer menuComponentPeer = this.getPeer();
        if (!(menuComponentPeer instanceof CMenuItem)) {
            return;
        }
        CMenuItem cMenuItem = (CMenuItem)menuComponentPeer;
        Image image = null;
        if (icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            image = AquaIcon.getImageForIcon(icon);
        }
        cMenuItem.setImage(image);
    }

    public void setVisible(boolean bl) {
        if (this.fParent == null) {
            this.fParent = this.getParent();
        }
        ((ScreenMenuPropertyHandler)((Object)this.fParent)).setChildVisible(this.fMenuItem, bl);
    }

    @Override
    public void setChildVisible(JMenuItem jMenuItem, boolean bl) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this) {
            this.fMenuItem.doClick(0);
            return;
        }
        switch (itemEvent.getStateChange()) {
            case 1: {
                this.setState(true);
                break;
            }
            case 2: {
                this.setState(false);
            }
        }
    }

    @Override
    public void setIndeterminate(boolean bl) {
        MenuComponentPeer menuComponentPeer = this.getPeer();
        if (menuComponentPeer instanceof CCheckboxMenuItem) {
            ((CCheckboxMenuItem)menuComponentPeer).setIsIndeterminate(bl);
        }
    }
}

