/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaFonts;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import sun.security.action.GetPropertyAction;

public class AquaUtilControlSize {
    protected static final String CLIENT_PROPERTY_KEY = "JComponent.sizeVariant";
    protected static final String SYSTEM_PROPERTY_KEY = "swing.component.sizevariant";
    protected static final AquaUtils.LazySingleton<PropertySizeListener> sizeListener = new AquaUtils.LazySingletonFromDefaultConstructor<PropertySizeListener>(PropertySizeListener.class);
    protected static final JRSUIConstants.Size defaultSize = AquaUtilControlSize.getDefaultSize();

    protected static PropertySizeListener getSizeListener() {
        return sizeListener.get();
    }

    protected static void addSizePropertyListener(JComponent jComponent) {
        jComponent.addPropertyChangeListener(CLIENT_PROPERTY_KEY, AquaUtilControlSize.getSizeListener());
        PropertySizeListener.applyComponentSize(jComponent, jComponent.getClientProperty(CLIENT_PROPERTY_KEY));
    }

    protected static void removeSizePropertyListener(JComponent jComponent) {
        jComponent.removePropertyChangeListener(CLIENT_PROPERTY_KEY, AquaUtilControlSize.getSizeListener());
    }

    private static JRSUIConstants.Size getSizeFromString(String string) {
        if ("regular".equalsIgnoreCase(string)) {
            return JRSUIConstants.Size.REGULAR;
        }
        if ("small".equalsIgnoreCase(string)) {
            return JRSUIConstants.Size.SMALL;
        }
        if ("mini".equalsIgnoreCase(string)) {
            return JRSUIConstants.Size.MINI;
        }
        if ("large".equalsIgnoreCase(string)) {
            return JRSUIConstants.Size.LARGE;
        }
        return null;
    }

    private static JRSUIConstants.Size getDefaultSize() {
        String string = AccessController.doPrivileged(new GetPropertyAction(SYSTEM_PROPERTY_KEY));
        JRSUIConstants.Size size = AquaUtilControlSize.getSizeFromString(string);
        if (size != null) {
            return size;
        }
        return JRSUIConstants.Size.REGULAR;
    }

    protected static JRSUIConstants.Size getUserSizeFrom(JComponent jComponent) {
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY_KEY);
        if (object == null) {
            return defaultSize;
        }
        JRSUIConstants.Size size = AquaUtilControlSize.getSizeFromString(object.toString());
        if (size == null) {
            return JRSUIConstants.Size.REGULAR;
        }
        return size;
    }

    protected static JRSUIConstants.Size applySizeForControl(JComponent jComponent, AquaPainter<? extends JRSUIState> aquaPainter) {
        JRSUIConstants.Size size = AquaUtilControlSize.getUserSizeFrom(jComponent);
        JRSUIConstants.Size size2 = size == null ? JRSUIConstants.Size.REGULAR : size;
        ((JRSUIState)aquaPainter.state).set(size2);
        return size2;
    }

    protected static Font getFontForSize(Component component, JRSUIConstants.Size size) {
        Font font = component.getFont();
        if (size == null || !(font instanceof UIResource)) {
            return font;
        }
        if (size == JRSUIConstants.Size.MINI) {
            return font.deriveFont(AquaFonts.getMiniControlTextFont().getSize2D());
        }
        if (size == JRSUIConstants.Size.SMALL) {
            return font.deriveFont(AquaFonts.getSmallControlTextFont().getSize2D());
        }
        return font.deriveFont(AquaFonts.getControlTextFont().getSize2D());
    }

    private static void applyBorderForSize(JComponent jComponent, JRSUIConstants.Size size) {
        Border border = jComponent.getBorder();
        if (!(border instanceof AquaBorder)) {
            return;
        }
        AquaBorder aquaBorder = (AquaBorder)border;
        if (aquaBorder.sizeVariant.size == size) {
            return;
        }
        AquaBorder aquaBorder2 = aquaBorder.deriveBorderForSize(size);
        if (aquaBorder2 == null) {
            return;
        }
        jComponent.setBorder(aquaBorder2);
    }

    private static void applyUISizing(JComponent jComponent, JRSUIConstants.Size size) {
        try {
            Class<?> clazz = jComponent.getClass();
            Method method = clazz.getMethod("getUI", new Class[0]);
            Object object = method.invoke((Object)jComponent, new Object[0]);
            if (!(object instanceof Sizeable)) {
                return;
            }
            Sizeable sizeable = (Sizeable)object;
            sizeable.applySizeFor(jComponent, size);
        }
        finally {
            return;
        }
    }

    public static class SizeVariant {
        JRSUIConstants.Size size = JRSUIConstants.Size.REGULAR;
        Insets insets = new InsetsUIResource(0, 0, 0, 0);
        Insets margins = new InsetsUIResource(0, 0, 0, 0);
        Float fontSize;
        int w = 0;
        int h = 0;

        public SizeVariant() {
        }

        public SizeVariant(int n, int n2) {
            this.w = n;
            this.h = n2;
        }

        public SizeVariant(SizeVariant sizeVariant) {
            this.size = sizeVariant.size;
            this.insets = new InsetsUIResource(sizeVariant.insets.top, sizeVariant.insets.left, sizeVariant.insets.bottom, sizeVariant.insets.right);
            this.margins = new InsetsUIResource(sizeVariant.margins.top, sizeVariant.margins.left, sizeVariant.margins.bottom, sizeVariant.margins.right);
            this.fontSize = sizeVariant.fontSize;
            this.w = sizeVariant.w;
            this.h = sizeVariant.h;
        }

        public SizeVariant replaceInsets(String string) {
            this.insets = UIManager.getInsets(string);
            return this;
        }

        public SizeVariant replaceInsets(Insets insets) {
            this.insets = new InsetsUIResource(insets.top, insets.left, insets.bottom, insets.right);
            return this;
        }

        public SizeVariant alterInsets(int n, int n2, int n3, int n4) {
            this.insets = SizeVariant.generateInsets(this.insets, n, n2, n3, n4);
            return this;
        }

        public SizeVariant replaceMargins(String string) {
            this.margins = UIManager.getInsets(string);
            return this;
        }

        public SizeVariant alterMargins(int n, int n2, int n3, int n4) {
            this.margins = SizeVariant.generateInsets(this.margins, n, n2, n3, n4);
            return this;
        }

        public SizeVariant alterFontSize(float f) {
            float f2 = this.fontSize == null ? 0.0f : this.fontSize.floatValue();
            this.fontSize = new Float(f + f2);
            return this;
        }

        public SizeVariant alterMinSize(int n, int n2) {
            this.w += n;
            this.h += n2;
            return this;
        }

        static Insets generateInsets(Insets insets, int n, int n2, int n3, int n4) {
            if (insets == null) {
                return new InsetsUIResource(n, n2, n3, n4);
            }
            insets.top += n;
            insets.left += n2;
            insets.bottom += n3;
            insets.right += n4;
            return insets;
        }

        public String toString() {
            return "insets:" + this.insets + ", margins:" + this.margins + ", fontSize:" + this.fontSize;
        }
    }

    public static class SizeDescriptor {
        SizeVariant regular;
        SizeVariant small;
        SizeVariant mini;

        public SizeDescriptor(SizeVariant sizeVariant) {
            this.regular = this.deriveRegular(sizeVariant);
            this.small = this.deriveSmall(new SizeVariant(this.regular));
            this.mini = this.deriveMini(new SizeVariant(this.small));
        }

        public SizeVariant deriveRegular(SizeVariant sizeVariant) {
            sizeVariant.size = JRSUIConstants.Size.REGULAR;
            return sizeVariant;
        }

        public SizeVariant deriveSmall(SizeVariant sizeVariant) {
            sizeVariant.size = JRSUIConstants.Size.SMALL;
            return sizeVariant;
        }

        public SizeVariant deriveMini(SizeVariant sizeVariant) {
            sizeVariant.size = JRSUIConstants.Size.MINI;
            return sizeVariant;
        }

        public SizeVariant get(JComponent jComponent) {
            if (jComponent == null) {
                return this.regular;
            }
            return this.get(AquaUtilControlSize.getUserSizeFrom(jComponent));
        }

        public SizeVariant get(JRSUIConstants.Size size) {
            if (size == JRSUIConstants.Size.REGULAR) {
                return this.regular;
            }
            if (size == JRSUIConstants.Size.SMALL) {
                return this.small;
            }
            if (size == JRSUIConstants.Size.MINI) {
                return this.mini;
            }
            return this.regular;
        }

        public String toString() {
            return "regular[" + this.regular + "] small[" + this.small + "] mini[" + this.mini + "]";
        }
    }

    protected static class PropertySizeListener
    implements PropertyChangeListener {
        protected PropertySizeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!AquaUtilControlSize.CLIENT_PROPERTY_KEY.equalsIgnoreCase(string)) {
                return;
            }
            Object object = propertyChangeEvent.getSource();
            if (!(object instanceof JComponent)) {
                return;
            }
            JComponent jComponent = (JComponent)object;
            PropertySizeListener.applyComponentSize(jComponent, propertyChangeEvent.getNewValue());
        }

        protected static void applyComponentSize(JComponent jComponent, Object object) {
            JRSUIConstants.Size size = AquaUtilControlSize.getSizeFromString(object == null ? null : object.toString());
            if (size == null && (size = AquaUtilControlSize.getUserSizeFrom(jComponent)) == JRSUIConstants.Size.REGULAR) {
                return;
            }
            AquaUtilControlSize.applyBorderForSize(jComponent, size);
            AquaUtilControlSize.applyUISizing(jComponent, size);
            Font font = jComponent.getFont();
            if (!(font instanceof FontUIResource)) {
                return;
            }
            jComponent.setFont(AquaUtilControlSize.getFontForSize(jComponent, size));
        }
    }

    static interface Sizeable {
        public void applySizeFor(JComponent var1, JRSUIConstants.Size var2);
    }
}

