/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;

public class AquaToolBarUI
extends BasicToolBarUI
implements SwingConstants {
    private static AquaUtils.LazySingleton<ToolBarBorder> toolBarBorder = new AquaUtils.LazySingletonFromDefaultConstructor<ToolBarBorder>(ToolBarBorder.class);

    public static Border getToolBarBorder() {
        return toolBarBorder.get();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaToolBarUI();
    }

    @Override
    protected void setBorderToNonRollover(Component component) {
    }

    @Override
    protected void setBorderToNormal(Component component) {
    }

    @Override
    protected void setBorderToRollover(Component component) {
    }

    @Override
    protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
        RootPaneContainer rootPaneContainer = super.createFloatingWindow(jToolBar);
        rootPaneContainer.getRootPane().putClientProperty("Window.style", "small");
        return rootPaneContainer;
    }

    static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        ToolBarBorder() {
        }

        protected void fillHandle(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
            graphics.setColor(UIManager.getColor("ToolBar.borderHandleColor"));
            if (bl) {
                int n5 = n4 - n2 - 2;
                graphics.fillRect(n + 2, n2 + 1, 1, n5);
                graphics.fillRect(n + 5, n2 + 1, 1, n5);
            } else {
                int n6 = n3 - n - 2;
                graphics.fillRect(n + 1, n2 + 2, n6, 1);
                graphics.fillRect(n + 1, n2 + 5, n6, 1);
            }
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl;
            Color color;
            graphics.translate(n, n2);
            if (component.isOpaque()) {
                color = component.getBackground();
                graphics.setColor(color);
                graphics.fillRect(0, 0, n3 - 1, n4 - 1);
            }
            color = graphics.getColor();
            JToolBar jToolBar = (JToolBar)component;
            ComponentOrientation componentOrientation = jToolBar.getComponentOrientation();
            boolean bl2 = bl = jToolBar.getOrientation() == 0;
            if (jToolBar.isFloatable()) {
                if (bl) {
                    if (componentOrientation.isLeftToRight()) {
                        this.fillHandle(graphics, 2, 2, 10, n4 - 2, true);
                    } else {
                        this.fillHandle(graphics, n3 - 10, 2, n3 - 2, n4 - 2, true);
                    }
                } else {
                    this.fillHandle(graphics, 2, 2, n3 - 2, 10, false);
                }
            }
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(5, 5, 5, 5);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2;
            insets.left = 4;
            insets.right = 4;
            insets.top = 2;
            insets.bottom = 2;
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    insets.left = 12;
                } else {
                    insets.top = 12;
                }
            }
            if ((insets2 = ((JToolBar)component).getMargin()) != null) {
                insets.left += insets2.left;
                insets.top += insets2.top;
                insets.right += insets2.right;
                insets.bottom += insets2.bottom;
            }
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

