/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt.event;

import com.apple.eawt.event.GestureListener;
import com.apple.eawt.event.GesturePhaseEvent;
import com.apple.eawt.event.GesturePhaseListener;
import com.apple.eawt.event.MagnificationEvent;
import com.apple.eawt.event.MagnificationListener;
import com.apple.eawt.event.RotationEvent;
import com.apple.eawt.event.RotationListener;
import com.apple.eawt.event.SwipeEvent;
import com.apple.eawt.event.SwipeListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

final class GestureHandler {
    private static final String CLIENT_PROPERTY = "com.apple.eawt.event.internalGestureHandler";
    static final int PHASE = 1;
    static final int ROTATE = 2;
    static final int MAGNIFY = 3;
    static final int SWIPE = 4;
    final List<GesturePhaseListener> phasers = new LinkedList<GesturePhaseListener>();
    final List<RotationListener> rotaters = new LinkedList<RotationListener>();
    final List<MagnificationListener> magnifiers = new LinkedList<MagnificationListener>();
    final List<SwipeListener> swipers = new LinkedList<SwipeListener>();

    static void addGestureListenerTo(JComponent jComponent, GestureListener gestureListener) {
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY);
        if (object instanceof GestureHandler) {
            ((GestureHandler)object).addListener(gestureListener);
            return;
        }
        if (object != null) {
            return;
        }
        GestureHandler gestureHandler = new GestureHandler();
        gestureHandler.addListener(gestureListener);
        jComponent.putClientProperty(CLIENT_PROPERTY, gestureHandler);
    }

    static void removeGestureListenerFrom(JComponent jComponent, GestureListener gestureListener) {
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY);
        if (!(object instanceof GestureHandler)) {
            return;
        }
        ((GestureHandler)object).removeListener(gestureListener);
    }

    static void handleGestureFromNative(final Window window, final int n, final double d, final double d2, final double d3, final double d4) {
        if (window == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component component = SwingUtilities.getDeepestComponentAt(window, (int)d, (int)d2);
                PerComponentNotifier perComponentNotifier = component instanceof RootPaneContainer ? GestureHandler.getNextNotifierForComponent(((RootPaneContainer)((Object)component)).getRootPane()) : GestureHandler.getNextNotifierForComponent(component);
                if (perComponentNotifier == null) {
                    return;
                }
                switch (n) {
                    case 1: {
                        perComponentNotifier.recursivelyHandlePhaseChange(d3, new GesturePhaseEvent());
                        return;
                    }
                    case 2: {
                        perComponentNotifier.recursivelyHandleRotate(new RotationEvent(d3));
                        return;
                    }
                    case 3: {
                        perComponentNotifier.recursivelyHandleMagnify(new MagnificationEvent(d3));
                        return;
                    }
                    case 4: {
                        perComponentNotifier.recursivelyHandleSwipe(d3, d4, new SwipeEvent());
                        return;
                    }
                }
            }
        });
    }

    GestureHandler() {
    }

    void addListener(GestureListener gestureListener) {
        if (gestureListener instanceof GesturePhaseListener) {
            this.phasers.add((GesturePhaseListener)gestureListener);
        }
        if (gestureListener instanceof RotationListener) {
            this.rotaters.add((RotationListener)gestureListener);
        }
        if (gestureListener instanceof MagnificationListener) {
            this.magnifiers.add((MagnificationListener)gestureListener);
        }
        if (gestureListener instanceof SwipeListener) {
            this.swipers.add((SwipeListener)gestureListener);
        }
    }

    void removeListener(GestureListener gestureListener) {
        this.phasers.remove(gestureListener);
        this.rotaters.remove(gestureListener);
        this.magnifiers.remove(gestureListener);
        this.swipers.remove(gestureListener);
    }

    static GestureHandler getHandlerForComponent(Component component) {
        if (!(component instanceof JComponent)) {
            return null;
        }
        Object object = ((JComponent)component).getClientProperty(CLIENT_PROPERTY);
        if (!(object instanceof GestureHandler)) {
            return null;
        }
        return (GestureHandler)object;
    }

    static PerComponentNotifier getNextNotifierForComponent(Component component) {
        if (component == null) {
            return null;
        }
        GestureHandler gestureHandler = GestureHandler.getHandlerForComponent(component);
        if (gestureHandler != null) {
            return new PerComponentNotifier(component, gestureHandler);
        }
        return GestureHandler.getNextNotifierForComponent(component.getParent());
    }

    static class PerComponentNotifier {
        final Component component;
        final GestureHandler handler;

        public PerComponentNotifier(Component component, GestureHandler gestureHandler) {
            this.component = component;
            this.handler = gestureHandler;
        }

        void recursivelyHandlePhaseChange(double d, GesturePhaseEvent gesturePhaseEvent) {
            for (GesturePhaseListener gesturePhaseListener : this.handler.phasers) {
                if (d < 0.0) {
                    gesturePhaseListener.gestureBegan(gesturePhaseEvent);
                } else {
                    gesturePhaseListener.gestureEnded(gesturePhaseEvent);
                }
                if (!gesturePhaseEvent.isConsumed()) continue;
                return;
            }
            PerComponentNotifier perComponentNotifier = GestureHandler.getNextNotifierForComponent(this.component.getParent());
            if (perComponentNotifier != null) {
                perComponentNotifier.recursivelyHandlePhaseChange(d, gesturePhaseEvent);
            }
        }

        void recursivelyHandleRotate(RotationEvent rotationEvent) {
            for (RotationListener rotationListener : this.handler.rotaters) {
                rotationListener.rotate(rotationEvent);
                if (!rotationEvent.isConsumed()) continue;
                return;
            }
            PerComponentNotifier perComponentNotifier = GestureHandler.getNextNotifierForComponent(this.component.getParent());
            if (perComponentNotifier != null) {
                perComponentNotifier.recursivelyHandleRotate(rotationEvent);
            }
        }

        void recursivelyHandleMagnify(MagnificationEvent magnificationEvent) {
            for (MagnificationListener magnificationListener : this.handler.magnifiers) {
                magnificationListener.magnify(magnificationEvent);
                if (!magnificationEvent.isConsumed()) continue;
                return;
            }
            PerComponentNotifier perComponentNotifier = GestureHandler.getNextNotifierForComponent(this.component.getParent());
            if (perComponentNotifier != null) {
                perComponentNotifier.recursivelyHandleMagnify(magnificationEvent);
            }
        }

        void recursivelyHandleSwipe(double d, double d2, SwipeEvent swipeEvent) {
            for (SwipeListener swipeListener : this.handler.swipers) {
                if (d < 0.0) {
                    swipeListener.swipedLeft(swipeEvent);
                }
                if (d > 0.0) {
                    swipeListener.swipedRight(swipeEvent);
                }
                if (d2 < 0.0) {
                    swipeListener.swipedDown(swipeEvent);
                }
                if (d2 > 0.0) {
                    swipeListener.swipedUp(swipeEvent);
                }
                if (!swipeEvent.isConsumed()) continue;
                return;
            }
            PerComponentNotifier perComponentNotifier = GestureHandler.getNextNotifierForComponent(this.component.getParent());
            if (perComponentNotifier != null) {
                perComponentNotifier.recursivelyHandleSwipe(d, d2, swipeEvent);
            }
        }
    }
}

