/*
 * Decompiled with CFR 0.152.
 */
package apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIControl;

public class JRSUIUtils {
    static boolean isLeopard = JRSUIUtils.isMacOSXLeopard();
    static boolean isSnowLeopardOrBelow = JRSUIUtils.isMacOSXSnowLeopardOrBelow();

    static boolean isMacOSXLeopard() {
        return JRSUIUtils.isCurrentMacOSXVersion(5);
    }

    static boolean isMacOSXSnowLeopardOrBelow() {
        return JRSUIUtils.currentMacOSXVersionMatchesGivenVersionRange(6, true, true, false);
    }

    static boolean isCurrentMacOSXVersion(int n) {
        return JRSUIUtils.currentMacOSXVersionMatchesGivenVersionRange(n, true, false, false);
    }

    static boolean currentMacOSXVersionMatchesGivenVersionRange(int n, boolean bl, boolean bl2, boolean bl3) {
        String string = System.getProperty("os.version");
        String[] stringArray = string.split("\\.");
        if (!stringArray[0].equals("10")) {
            return false;
        }
        if (stringArray.length < 2) {
            return false;
        }
        try {
            int n2 = Integer.parseInt(stringArray[1]);
            if (bl && n2 == n) {
                return true;
            }
            if (bl2 && n2 < n) {
                return true;
            }
            if (bl3 && n2 > n) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public static class HitDetection {
        public static JRSUIConstants.Hit getHitForPoint(JRSUIControl jRSUIControl, double d, double d2, double d3, double d4, double d5, double d6) {
            return jRSUIControl.getHitForPoint(d, d2, d3, d4, d5, d6);
        }
    }

    public static class Images {
        public static boolean shouldUseLegacySecurityUIPath() {
            return isSnowLeopardOrBelow;
        }
    }

    public static class ScrollBar {
        private static native boolean shouldUseScrollToClick();

        public static boolean useScrollToClick() {
            return ScrollBar.shouldUseScrollToClick();
        }

        public static void getPartBounds(double[] dArray, JRSUIControl jRSUIControl, double d, double d2, double d3, double d4, JRSUIConstants.ScrollBarPart scrollBarPart) {
            jRSUIControl.getPartBounds(dArray, d, d2, d3, d4, scrollBarPart.ordinal);
        }

        public static double getNativeOffsetChange(JRSUIControl jRSUIControl, double d, double d2, double d3, double d4, int n, int n2, int n3) {
            return jRSUIControl.getScrollBarOffsetChange(d, d2, d3, d4, n, n2, n3);
        }
    }

    public static class Tree {
        public static boolean useLegacyTreeKnobs() {
            return isLeopard;
        }
    }

    public static class InternalFrame {
        public static boolean shouldUseLegacyBorderMetrics() {
            return isSnowLeopardOrBelow;
        }
    }

    public static class TabbedPane {
        public static boolean useLegacyTabs() {
            return isLeopard;
        }

        public static boolean shouldUseTabbedPaneContrastUI() {
            return !isSnowLeopardOrBelow;
        }
    }
}

